# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, stamp2datetime, interface_response, online_employee, \
    save_notification, save_history, approve_flow, remove_history, SUCCESS_CODE, MESSAGE_CODE, \
    SYSTEM_EXCEPTION, DATA_EXCEPTION, datetime2stamp, user_photo, paging
from django.utils.translation import ugettext_lazy as _
import json


class BioTimeAppMyApplication(object):

    """
    【My Application】我的申请
    """

    @request_valid
    @ladonize(int, int, int, str, str, rtype=str)
    def my_application(self, category, approve_status, page_num, language, token):
        """
        获取自己的补签卡申请(申请,通过,拒绝)数据
        @param category:        类型(1:请假，2：加班 3：补签， 4：培训， 5：调班)
        @param approve_status:  0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:        页码（每页１５条数据）
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                category = 1（请假）
                {"code":1,"error":"","describe":"","message":"","data":{"category":1, "items":[{"code": ID,"pin":"人员工号","name":"名称","photo":"照片地址","start":"请假开始时间(stamp)","end":"请假结束时间(stamp)","remark":"申请备注","category":"类型","apply_time":"申请时间","approve_status":"审核状态值","approve_describe":"审核状态","approved_remark":"审批备注", "approved_time":"审批时间"},]}}
                category = 2（加班）
                {"code":1,"error":"","describe":"","message":"","data":{"category":1, "items":[{"code": ID,"pin":"人员工号","name":"名称","photo":"照片地址","start":"加班开始时间(stamp)","end":"加班结束时间(stamp)","remark":"申请备注","category":"类型","apply_time":"申请时间","approve_status":"审核状态值","approve_describe":"审核状态","approved_remark":"审批备注", "approved_time":"审批时间"},]}}
                category = 3（补签）
                {"code":1,"error":"","describe":"","message":"","data":{"category":1, "items":[{"code": ID,"pin":"人员工号","name":"名称","photo":"照片地址","punch_time":"签卡时间(stamp)","remark":"申请备注","category":"类型","apply_time":"申请时间","approve_status":"审核状态值","approve_describe":"审核状态","approved_remark":"审批备注", "approved_time":"审批时间"},]}}
                category = 4（培训）
                {"code":1,"error":"","describe":"","message":"","data":{"category":1, "items":[{"code": ID,"pin":"人员工号","name":"名称","photo":"照片地址","start":"培训开始时间(stamp)","end":"培训结束时间(stamp)","remark":"申请备注","category":"类型","apply_time":"申请时间","approve_status":"审核状态值","approve_describe":"审核状态","approved_remark":"审批备注", "approved_time":"审批时间"},]}}
                category = 5（调班）
                {"code":1,"error":"","describe":"","message":"","data":{"category":1, "items":[{"code": ID,"pin":"人员工号","name":"名称","photo":"照片地址","previous_shift":"原班次","currently_shift":"调整班次,"remark":"申请备注","category":"类型","apply_time":"申请时间","approve_status":"审核状态值","approve_describe":"审核状态","approved_remark":"审批备注", "approved_time":"审批时间"},]}}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        from mysite.att.att_param import get_func_key
        from mysite.iclock.models.model_notification import CATEGORY_LEAVE, CATEGORY_OVERTIME, CATEGORY_MANUAL, \
            CATEGORY_TRAINING, CATEGORY_SCHEDULE

        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            if not approve_status:
                _approve_status = ' audit_status in (2, 3) '
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            sort_name = 'change_time'
            if approve_status in (1, ):
                sort_name = 'create_time'
            where = ' u.userid = %(applier)s and %(audit_status)s  ' % ({'applier': emp.pk, 'audit_status': _approve_status})
            page_num = page_num or 1
            try:
                data = {
                    'category': category,
                    'items': []
                }
                params = {'where': where}
                if category in (CATEGORY_MANUAL, ):
                    sql = get_sql('sql', sqlid='manual_punch_application', app="pywebsv", params=params)
                    sql = paging(sql, page_num, sort_name)
                    rows = p_query(sql)
                    if rows:
                        status = dict(constant.ALL_STATUS)
                        items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                                  'punch_time': datetime2stamp(r[3]), 'remark': r[5], 'category': get_func_key(r[4]),
                                  'apply_time': datetime2stamp(r[6]), 'approve_status': r[7],
                                  'approve_describe': u'{0}'.format(status.get(r[7], r[7])),
                                  'approved_remark':r[9], 'approved_time': datetime2stamp(r[10])} for r in rows]
                        data['items'] = items
                elif category in (CATEGORY_LEAVE, ):
                    sql = get_sql('sql', sqlid='leave_application', app="pywebsv", params=params)
                    sql = paging(sql, page_num, sort_name)
                    rows = p_query(sql)
                    if rows:
                        status = dict(constant.ALL_STATUS)
                        items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                                  'start': datetime2stamp(r[3]), 'end': datetime2stamp(r[4]),
                                  'remark': r[5], 'category': r[6], 'apply_time': datetime2stamp(r[7]),
                                  'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                                  'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])} for r in rows]
                        data['items'] = items
                elif category in (CATEGORY_OVERTIME, ):
                    sql = get_sql('sql', sqlid='overtime_application', app="pywebsv", params=params)
                    sql = paging(sql, page_num, sort_name)
                    rows = p_query(sql)
                    if rows:
                        status = dict(constant.ALL_STATUS)
                        types = dict(constant.OT_TYPE)
                        items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                                  'start': datetime2stamp(r[3]), 'end': datetime2stamp(r[4]),
                                  'remark': r[5], 'category': u'{0}'.format(types.get(r[6], r[6])),
                                  'apply_time': datetime2stamp(r[7]),
                                  'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                                  'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])} for r in rows]
                        data['items'] = items
                elif category in (CATEGORY_TRAINING, ):
                    sql = get_sql('sql', sqlid='training_application', app="pywebsv", params=params)
                    sql = paging(sql, page_num, sort_name)
                    rows = p_query(sql)
                    if rows:
                        status = dict(constant.ALL_STATUS)
                        items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                                  'start': datetime2stamp(r[3]), 'end': datetime2stamp(r[4]),
                                  'remark': r[5], 'category': r[6], 'apply_time': datetime2stamp(r[7]),
                                  'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                                  'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])} for r in rows]
                        data['items'] = items
                elif category in (CATEGORY_SCHEDULE, ):
                    sql = get_sql('sql', sqlid='schedule_application', app="pywebsv", params=params)
                    sql = paging(sql, page_num, sort_name)
                    rows = p_query(sql)
                    if rows:
                        status = dict(constant.ALL_STATUS)
                        items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                                  'previous_shift': r[3] or 'None', 'currently_shift': r[4],
                                  'remark': r[5], 'category': r[6].strftime('%Y-%m-%d'), 'apply_time': datetime2stamp(r[7]),
                                  'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                                  'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])} for r in rows]
                        data['items'] = items
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'parameter approve_status={0} error'.format(approve_status)
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, str, str, rtype=str)
    def cancel(self, category, code, language, token):
        """
        删除自己的申请
        @param category:        类型(1:请假，2：加班 3：补签， 4：培训， 5：调班)
        @param code:            对象ID
        @param language:
        @param token:
        @rtype:
        """
        from mysite.att import constant
        from mysite.iclock.models.model_notification import CATEGORY_LEAVE, CATEGORY_OVERTIME, CATEGORY_MANUAL, \
            CATEGORY_TRAINING, CATEGORY_SCHEDULE
        objs = None
        try:
            if category in (CATEGORY_MANUAL, ):
                from mysite.att.models.checkexact_model import CheckExact
                objs = CheckExact.objects.filter(id=code)
            elif category in (CATEGORY_LEAVE, ):
                from mysite.att.models.model_empspecday import EmpSpecDay
                objs = EmpSpecDay.objects.filter(id=code)
            elif category in (CATEGORY_OVERTIME, ):
                from mysite.att.models.model_overtime import OverTime
                objs = OverTime.objects.filter(id=code)
            elif category in (CATEGORY_TRAINING, ):
                from mysite.att.models.model_training import Training
                objs = Training.objects.filter(id=code)
            elif category in (CATEGORY_SCHEDULE, ):
                from mysite.att.models.model_schedule import ChangeSchedule
                objs = ChangeSchedule.objects.filter(id=code)
            if objs:
                obj = objs[0]
                if obj.audit_status in (constant.AUDIT_SUCCESS, constant.REFUSE):
                    message = u'{0}'.format(_(u'Approved application can not delete.'))
                    return interface_response(MESSAGE_CODE, '', '', '', message)
                else:
                    obj.delete()
                    remove_history(category, obj.pk)
                    data = {
                        "message": u'{0}'.format(_(u'Removed Successful'))
                    }
                    return interface_response(SUCCESS_CODE, json.dumps(data), '')
            else:
                describe = 'Object Not Found'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)




